/*
 * Decompiled with CFR 0.152.
 */
package reliquary.entities.shot;

import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import reliquary.entities.ConcussiveExplosion;
import reliquary.entities.shot.ShotEntityBase;
import reliquary.init.ModEntities;
import reliquary.reference.ClientReference;

public class BusterShotEntity
extends ShotEntityBase {
    public BusterShotEntity(EntityType<BusterShotEntity> entityType, Level world) {
        super(entityType, world);
    }

    public BusterShotEntity(Level world, Player player, InteractionHand hand) {
        super((EntityType)ModEntities.BUSTER_SHOT.get(), world, player, hand);
    }

    @Override
    void doBurstEffect(Direction sideHit) {
        ConcussiveExplosion.customBusterExplosion((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 4.0f);
    }

    @Override
    void doFiringEffects() {
        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123770_, this.m_20185_() + this.smallGauss(0.1), this.m_20186_() + this.smallGauss(0.1), this.m_20189_() + this.smallGauss(0.1), 0.5, 0.5, 0.5);
        this.spawnMotionBasedParticle((ParticleOptions)ParticleTypes.f_123744_);
    }

    @Override
    void doFlightEffects() {
        if (this.ticksInAir % 3 == 0) {
            this.spawnMotionBasedParticle((ParticleOptions)ParticleTypes.f_123762_);
        }
    }

    @Override
    void spawnHitParticles(int i) {
    }

    @Override
    protected void onImpact(LivingEntity entityLiving) {
        ConcussiveExplosion.customBusterExplosion((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 4.0f);
        super.onImpact(entityLiving);
    }

    @Override
    int getRicochetMax() {
        return 0;
    }

    @Override
    int getDamageOfShot(LivingEntity mop) {
        return 8 + this.d6();
    }

    @Override
    public ResourceLocation getShotTexture() {
        return ClientReference.BUSTER;
    }
}

